#ifndef LANG_IT_H
#define LANG_IT_H

// ========== MENSAJES DE suite_kiss.ino ==========
#define LANG_HELLO_MESSAGE "🔌 Ciao.\nComunicazione stabilita\n\n🔨 Compilato: %s\n🔢 Hash: 0x%08X\n📦 Versione: %s\n📊 Stato:\nRiavvii: %d\nTempo attivo: %lu sec\nRAM libera: %d bytes\nMessaggi in sospeso: %d\n📡 Segnale WiFi: %d dBm (%s)"

// Qualità del segnale WiFi
#define LANG_WIFI_EXCELLENT "Eccellente"
#define LANG_WIFI_GOOD "Buono"
#define LANG_WIFI_FAIR "Discreto"
#define LANG_WIFI_WEAK "Debole"

// Comando /estado
#define LANG_STATUS_TITLE_RELIABILITY "🎯 AFFIDABILITÀ SISTEMA"
#define LANG_STATUS_SYSTEM "Sistema"
#define LANG_STATUS_RELIABLE "AFFIDABILE"
#define LANG_STATUS_CHECK "VERIFICARE"
#define LANG_STATUS_SENT "Messaggi inviati"
#define LANG_STATUS_PENDING "Messaggi in sospeso"
#define LANG_STATUS_LOST "Messaggi persi"
#define LANG_STATUS_DISCARDED "Scartati (coda piena)"
#define LANG_STATUS_TITLE_EXTERNAL "🌐 AVVERSITÀ ESTERNE"
#define LANG_STATUS_ERRORS "Errori totali"
#define LANG_STATUS_RECOVERED "Recuperati (fallback)"
#define LANG_STATUS_WIFI_DROPS "Cadute WiFi"
#define LANG_STATUS_TITLE_TECHNICAL "📊 INFORMAZIONI TECNICHE"
#define LANG_STATUS_UPTIME "Tempo di funzionamento"
#define LANG_STATUS_FREE_RAM "RAM libera"
#define LANG_STATUS_FREE_PSRAM "PSRAM libera"
#define LANG_STATUS_FREE_FS "FS libero"
#define LANG_STATUS_MAX_FS "Max. in FS"
#define LANG_STATUS_MESSAGES "Messaggi"
#define LANG_STATUS_POWER_MODE "Modalità energia"
#define LANG_STATUS_WIFI_SIGNAL "Segnale WiFi"
#define LANG_STATUS_SSL "SSL"
#define LANG_STATUS_SSL_SECURE "SICURO"
#define LANG_STATUS_SSL_INSECURE "NON SICURO"
#define LANG_STATUS_TURBO "Turbo"
#define LANG_STATUS_ACTIVE "ATTIVO"
#define LANG_STATUS_INACTIVE "INATTIVO"
#define LANG_STATUS_AUTO_MSGS "Messaggi automatici"
#define LANG_STATUS_YES "SÌ"
#define LANG_STATUS_NO "NO"

// ========== KISSOTA.CPP =============
#define LANG_OTA_RUN_RUNN "⚠️ OTA già in corso"
#define LANG_OTA_PIN_BLOCK "🔒 PIN BLOCCATO\n\nPer sbloccare la funzione OTA, digita /otapuk [PUK]\nUna volta sbloccato, potrai avviare un nuovo processo con /ota\n\nSe non disponi del PUK, contatta l'amministratore."
#define LANG_OTA_INI_1 "📦 AGGIORNAMENTO OTA\n\nStiamo per avviare un aggiornamento del firmware del dispositivo.\n\nDurante l'aggiornamento:\n• I messaggi vengono memorizzati sul dispositivo\n• Non perderai messaggi\n• Non riceverai messaggi di comando\n• Per cancellare il processo, invia /otacancel\n\nDigita /otapin [PIN] per avviare il processo\n\n⏱️ Hai 60 secondi"
#define LANG_OTA_INI_TIMEOUT "⏱️ TIMEOUT\n\nIl tempo per inserire il PIN è scaduto.\nProcesso annullato.\n\nRiavvia con /ota"
#define LANG_OTA_GLOB_TIMEOUT "⏱️ TIMEOUT OTA\n\nIl processo ha superato il tempo massimo di 7 minuti.\nProcesso annullato.\n\nIl sistema ritorna al funzionamento normale.\nRiavvia con /ota"
#define LANG_OTA_PIN_OK "✅ PIN CORRETTO\n\nAvvio del processo di aggiornamento...\n\n• Messaggi in pausa\n• Verifica spazio disponibile\n• Creazione backup del firmware attuale\n\n⏱️ Timeout processo: 7 minuti\n\nNon spegnere il dispositivo."
#define LANG_OTA_ERROR_BACKUP "❌ ERRORE DI BACKUP\n\nImpossibile creare un backup del firmware attuale.\nProcesso annullato.\n\nIl sistema ritorna al funzionamento normale.\nRiavvia con /ota"
#define LANG_OTA_INI_2 "✅ BACKUP COMPLETATO\n\nFirmware attuale salvato correttamente.\n\n📤 Invia il file .bin del nuovo firmware"
#define LANG_OTA_PIN_BLOCKED "🔒 PIN BLOCCATO\n\nHai superato il massimo di 3 tentativi.\nIl processo attuale viene annullato.\n\nPer sbloccare la funzione OTA, digita /otapuk [PUK]\nUna volta sbloccato, potrai avviare un nuovo processo con /ota\n\nSe non disponi del PUK, contatta l'amministratore."
#define LANG_OTA_PIN_FAIL "❌ PIN errato\n\nTentativi rimanenti: %d\n\nDigita /otapin [PIN] per riprovare"
#define LANG_OTA_PIN_UBLOCK "🔓 OTA SBLOCCATO\n\nIl PIN è stato sbloccato con successo.\nI tentativi di PIN sono stati ripristinati.\n\nPer avviare un aggiornamento, digita /ota"
#define LANG_OTA_PUK_WRONG "❌ PUK errato"
#define LANG_OTA_PR_INACTI "❌ Nessun processo OTA attivo"
#define LANG_OTA_REVERT "🔄 AVVIO ROLLBACK\n\nRipristino del firmware precedente...\nIl dispositivo si riavvierà.\n\nNon spegnere il dispositivo."
#define LANG_OTA_CANCEL "🛑 PROCESSO ANNULLATO\n\nL'aggiornamento è stato annullato.\nNon sono state apportate modifiche al firmware.\n\nIl sistema ritorna al funzionamento normale."
#define LANG_OTA_FLASH "🔥 SCRITTURA FIRMWARE\n\nScrittura in memoria flash...\nPotrebbe richiedere alcuni minuti.\n\n⚠️ NON DISCONNETTERE IL DISPOSITIVO"
#define LANG_OTA_FLASH_F "❌ ERRORE DI SCRITTURA\n\nLa scrittura del firmware è fallita.\nAvvio del rollback automatico...\n\nIl dispositivo si riavvierà con il firmware precedente.\n\nNon spegnere il dispositivo."
#define LANG_OTA_VALIDATED "✅ FIRMWARE CONVALIDATO\n\nL'aggiornamento è stato completato con successo.\nBackup eliminato.\n\nIl sistema ritorna al funzionamento normale.\nI messaggi in sospeso verranno elaborati ora. (Puoi ignorare il precedente messaggio di convalida)"
#define LANG_OTA_NONVALID "❌ FILE NON VALIDO\n\nNome file non valido.\n\nInvia un file firmware .bin"
#define LANG_OTA_WRONG_EXT "❌ FILE NON VALIDO\n\nIl file deve essere .bin\nRicevuto: %s\n\nInvia un file firmware valido."
#define LANG_OTA_TOO_BIG "❌ FILE TROPPO GRANDE\n\nDimensione: %.2f MB\nMassimo: %.2f MB\n\nInvia un file più piccolo."
#define LANG_OTA_TOO_SMALL "⚠️ FILE MOLTO PICCOLO\n\nDimensione: %.1f KB\n\nSei sicuro che sia un firmware valido?"
#define LANG_OTA_DOWNLOADING "📥 DOWNLOAD DEL FIRMWARE\n\nRicezione file: %s\nDimensione: %.2f MB\n\nNon disconnettere il dispositivo."
#define LANG_OTA_DOWN_FAIL "❌ DOWNLOAD FALLITO\n\nImpossibile scaricare il firmware dopo 3 tentativi.\nPossibile causa: connessione WiFi instabile.\n\nProcesso annullato.\nRiavvia con /ota"
#define LANG_OTA_CHKSUM_VERI "🔍 VERIFICA INTEGRITÀ\n\nVerifica del checksum del firmware..."
#define LANG_OTA_CHKSUM_WRONG "❌ VERIFICA FALLITA\n\nIl file è corrotto o incompleto.\n\nProcesso annullato.\nRiavvia con /ota"
#define LANG_OTA_FILE_VERIFIED "✅ FIRMWARE VERIFICATO\n\nFile: %s\nDimensione: %.2f MB\nCRC32: 0x%08X\n⚠️CONFERMA SCRITTURA\n\n/otaconfirm - Scrivi ora\n/otacancel - Annulla processo\n\nTimeout: 3 minuti"
#define LANG_OTA_PIN_OUTTIME "TIMEOUT\n\n- Il tempo per inserire il PIN è scaduto.\n- Processo interrotto. Il sistema ritorna allo stato normale.\n\n- Riavvia con /ota"
#define LANG_OTA_PIN_OUT_VAL "⏱️ TIMEOUT CONVALIDA\n\nNessuna conferma ricevuta in 60 secondi.\nAvvio del rollback automatico...\n\nIl dispositivo si riavvierà con il firmware precedente"
#define LANG_OTA_TIMEOUT "⏱️ TIMEOUT OTA\n\nIl processo ha superato il tempo massimo di 7 minuti.\nProcesso annullato.\n\nIl sistema ritorna al funzionamento normale.\nRiavvia con /ota"
#define LANG_OTA_CHECK_FS "❌ ERRORE DI SISTEMA\n\nImpossibile accedere al file system.\nProcesso annullato."
#define LANG_OTA_NOT_ENOUGH "❌ SPAZIO INSUFFICIENTE\n\nSpazio insufficiente per creare il backup.\n\nNecessario: %.1f MB\nDisponibile: %.1f MB\n\nLibera spazio e riprova con /ota"
#define LANG_OTA_BEF_REBOOT "✅ SCRITTURA COMPLETATA\n\nFirmware scritto correttamente.\nIl dispositivo si riavvierà ora.\n\nDopo il riavvio, avrai 60 secondi per convalidare con /otaok\nSe non convalidato, verrà eseguito il rollback automatico."
#define LANG_OTA_QUEUE_MESS "⚠️ OTA INTERROTTO\n\nIl dispositivo si è riavviato durante il processo OTA.\nDownload parziale eliminato.\n\nIl sistema ritorna al funzionamento normale.\nRiavvia con /ota"
#define LANG_OTA_MAINT_MODE "🔄 CONVALIDA FIRMWARE\n\nIl dispositivo si è avviato.\n\n⏱️ Hai 60 secondi per convalidare\n\n/otaok - Conferma che funziona correttamente\n/otacancel - Forza il rollback al firmware precedente\n\nSe nessuna risposta, verrà eseguito il rollback automatico."
#define LANG_OTA_CRITI_ERROR "🔥 ERRORE CRITICO\n\nIl rollback è fallito.\nIl sistema potrebbe essere instabile.\n\nRichiede intervento manuale.\nContatta l'amministratore."
#define LANG_OTA_ERROR_RECOVER "🔥 ERRORE CRITICO\n\nIl ripristino è fallito.\nIl sistema potrebbe essere instabile.\n\nRichiede intervento manuale.\nContatta l'amministratore."
#define LANG_OTA_RECOVER_ERROR "❌ NESSUN BACKUP DISPONIBILE\n\nRipristino impossibile.\nIl sistema mantiene il firmware attuale."

// ========== KISSTELEGRAM.CPP ========
#define LANG_ERROR_CRITICAL_FS "❌ Errore inizializzazione LittleFS"
#define LANG_ERROR_SYSTEM_DES "🛑 KissTelegram distrutto"
#define LANG_INFO_MAINTENANCE_ON "⏸️ Modalità manutenzione attivata: %s"
#define LANG_INFO_MAINTENANCE_OFF "▶️ Modalità manutenzione disattivata"
#define LANG_INFO_CON_RESUME "🔗 Riutilizzando connessione precedente"
#define LANG_INFO_CON_DIE "🔌 Pulizia connessione morta"
#define LANG_INFO_CON_CLEAN "🔌 Errore %d - pulizia connessione"
#define LANG_INFO_FS_NEAR "❌ FS al %.1f%% - messaggio ignorato"
#define LANG_INFO_FS_FULL "❌ FS senza spazio - messaggio ignorato"
#define LANG_ERROR_FS_SAVE "❌ Errore salvataggio in LittleFS"
#define LANG_INFO_MSG_SENT "🚀 Turbo: %d inviati (%.1f msg/s)"
#define LANG_WARN_MSG_SEND "⚠️ Errore invio messaggio dalla coda"
#define LANG_WARN_MSG_DUP "⚠️ Update duplicato ignorato: %ld"
#define LANG_WARN_MSG_LEN "⚠️ Messaggio con lunghezza non valida: %d bytes"
#define LANG_WARN_NOID "⚠️ Messaggio senza chat_id valido - ignorato"
#define LANG_WARN_WRLEN "⚠️ file_id con lunghezza non valida: %d bytes"
#define LANG_WARN_TSSL "🔒 Tentando connessione SSL sicura..."
#define LANG_INFO_TSYNC "💡 TimeSynced: %s", timeSynced ? "SÌ" : "NO"
#define LANG_INFO_FRAM "💡 Free Heap: %d"
#define LANG_INFO_CERT "💡 Certificato CA configurato"
#define LANG_ERROR_SSLCLI "❌ sslClient è NULL"
#define LANG_INFO_TEST_BASIC "💡 Testando connettività di base..."
#define LANG_INFO_CON_BASIC "💡 Connettività di base: %s in %lu ms"
#define LANG_INFO_SSL_TEST "💡 Connessione SSL: %s in %lu ms", connected ? "RIUSCITA" : "FALLITA"
#define LANG_INFO_SSL_SUCC "✅ Connessione SSL riuscita in %lu ms"
#define LANG_INFO_CERT_VERI "✅ Certificato verificato correttamente"
#define LANG_INFO_CERT_FAIL "❌ Verifica certificato fallita"
#define LANG_WARN_CERT_FAIL "⚠️ Certificato non verificato (tempo non sincronizzato)"
#define LANG_ERROR_SSL_FAIL "❌ Connessione SSL fallita dopo %lu ms"
#define LANG_INFO_FRRAM "💡 Intestazione RAM: %d"
#define LANG_WARN_INSECURE "⚠️ Connessione insicura riuscita in %lu ms"
#define LANG_ERROR_INSECURE "❌ Connessione insicura fallita dopo %lu ms"
#define LANG_INFO_SSL_MSG "SSL Info:\n - Sicuro: %s\n - Ora sincronizzata: %s\n - Memoria libera: %d bytes\n - Client: %s", sslSecure ? "SÌ" : "NO", KissTime::getInstance().isTimeSynced() ? "SÌ" : "NO", ESP.getFreeHeap(), sslClient ? (sslClient->connected() ? "CONESSO" : "DISCONNESSO") : "NULL"
#define LANG_INFO_STOR_CLEAN "🗑️ Storage pulito completamente"
#define LANG_ERROR_MSG_TOLA "❌ Messaggio troppo lungo"
#define LANG_ERROR_MSG_WRIT "❌ Errore scrittura messaggio"
#define LANG_INFO_MSG_DEL "🗑️ Batch delete: %d messaggi eliminati"
#define LANG_INFO_FLUSH "🗑️ Flush finale - coda vuota"
#define LANG_INFO_MSG_QUEUE "📤 Elaborati %d messaggi dalla coda"
#define LANG_INFO_POWER_MODE "
🔋 ENERGIA:"
#define LANG_INFO_TUR_ACT "🚀 TURBO MODE ATTIVATO"
#define LANG_INFO_TUR_DEAC "🐢 TURBO MODE DISATTIVATO - %d msgs in %lu ms (%.1f msg/s)"
#define LANG_INFO_DIAG_1 "\n📊 DIAGNOSTICO KISSTELEGRAM:" KISS_SUITE_VERSION
#define LANG_INFO_DIAG_2 " - In sospeso: %d"
#define LANG_INFO_DIAG_3 " - WiFi: %s", isWifiStable() ? "STABILE" : "INSTABILE"
#define LANG_INFO_DIAG_4 " - Manutenzione: %s", maintenanceMode ? "ATTIVO" : "INATTIVO"
#define LANG_INFO_DIAG_5 " - Memoria: %d bytes"
#define LANG_INFO_STOR_1 "\n💾 STORAGE (FS diretto):"
#define LANG_INFO_STOR_2 " - In sospeso: %d"
#define LANG_INFO_STATS_1 "\n🎯 STATO:"
#define LANG_INFO_STATS_2 " - In sospeso: %d", countPendingMessages()
#define LANG_INFO_STATS_3 " - WiFi: %s", isWifiStable() ? "SÌ" : "NO"
#define LANG_INFO_STATS_4 "\n⚙️ CONFIG:"
#define LANG_INFO_STATS_5 " - Intervallo: %d ms"
#define LANG_INFO_STATS_6 " - Max storage: %d"
#define LANG_INFO_FS_PEND "💾 FS Diretto:\n - In sospeso: %d"
#define LANG_INFO_FS_DIAG "📊 " KISS_SUITE_VERSION"-FS-Diretto\n - In sospeso: %d\n - Memoria: %d"
#define LANG_INFO_CLOSE_CON "🕒 Chiusura connessione per anzianità (10 min)"
#define LANG_INFO_OTA_AUTHO "✅ OTA AUTORIZZATO"
#define LANG_INFO_SSL "🔒 INFO SSL (inviato a seriale)"
#define LANG_INFO_SSL_TEST_0 "🧪 KissTelegram: Testando connessione SSL..."
#define LANG_INFO_SSL_TEST_1 "📍 CHIAMATO da testSSLConnection"
#define LANG_INFO_SSL_TEST_2 "✅ KissTelegram: Test SSL RIUSCITO"
#define LANG_ERROR_SSL_TEST_3 "❌ KissTelegram: Test SSL FALLITO"
#define LANG_INFO_CON_LIM "⏱️ Connessione troppo veloce a Telegram limitata a (%lu ms)"
#define LANG_INFO_SSL_INTELL "🔄 Auto-regolazione SSL: %s → %s"
#define LANG_INFO_SSL_SUCC_1 "✅ Connessione SSL riuscita"
#define LANG_ERROR_SSL_FAIL_1 "❌ Connessione SSL fallita"
#define LANG_INFO_PING_TG "💓 Ping keep-alive a Telegram..."
#define LANG_INFO_PING_REP "💓 Risultato ping: %s (%d bytes)", foundOK ? "OK" : "FALLITO"


#endif